# DX_CC6_CORE_HOST_SIDE makefile
# TLK_SCLK_ATP component
#

COMP_NAME := $(TLK_SCLK_ATP_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(TLK_SCLK_ID) $(NVS_ID) $(SHARED_ATP_ID) $(TLK_ODRM_ID) $(TLK_CERT_ID) $(CRYS_KMNG_ID) $(KMNG_ID) $(SST_ID) $(CRYS_ID) $(VOS_ID) $(CC6_GEN_ID)

#id's of the components whose objects are used by this component
$(COMP_NAME)_USE_OBJ_IDS :=  $(SHARED_ATP_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(HOST_PATH)TLK_SCLK_TST/ATP_TST/tinc/ 

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(HOST_PATH)TLK_SCLK_TST/STP_TST/tinc/ \
	$(HOST_PATH)TLK_SCLK_TST/UTIL/tinc/

#global flags for this component
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := -DSCLK_ON_SEP

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	TLK_SCLK_ATP_data  \
	TLK_SCLK_ATP_Master_Clk_Update TLK_SCLK_ATP_menu \
	TLK_SCLK_ATP_Service_Clk_Gen_And_Service_Clk_Read TLK_SCLK_ATP_Service_Clk_Revalidate \
	TLK_SCLK_TST_UTIL TLK_SCLK_ATP_SecureClk_Toolkit_Authenticate

$(COMP_NAME)_MAIN_OBJ_NAMES := \
	TLK_SCLK_ATP_main

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@


$(OUT_OBJ_PATH)TLK_SCLK_ATP_data.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/ATP_TST/tsrc/TLK_SCLK_ATP_data.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)TLK_SCLK_ATP_Master_Clk_Update.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/ATP_TST/tsrc/TLK_SCLK_ATP_Master_Clk_Update.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)TLK_SCLK_ATP_menu.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/ATP_TST/tsrc/TLK_SCLK_ATP_menu.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)TLK_SCLK_ATP_Service_Clk_Gen_And_Service_Clk_Read.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/ATP_TST/tsrc/TLK_SCLK_ATP_Service_Clk_Gen_And_Service_Clk_Read.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)TLK_SCLK_ATP_Service_Clk_Revalidate.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/ATP_TST/tsrc/TLK_SCLK_ATP_Service_Clk_Revalidate.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)TLK_SCLK_ATP_SecureClk_Toolkit_Authenticate.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/ATP_TST/tsrc/TLK_SCLK_ATP_SecureClk_Toolkit_Authenticate.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)TLK_SCLK_TST_UTIL.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/UTIL/tsrc/TLK_SCLK_TST_UTIL.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)TLK_SCLK_ATP_main.$(OBJEXT): $(HOST_PATH)TLK_SCLK_TST/ATP_TST/tsrc/TLK_SCLK_ATP_main.c
	$(TLK_SCLK_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

